<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCancelRequestTable extends Migration {

	public function up()
	{
		Schema::create('cancel_request', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('subscription_id')->nullable();
			$table->integer('user_id')->nullable();
			$table->text('note')->nullable();
			$table->enum('status', array('awating', 'rejected', 'approved'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('cancel_request');
	}
}