<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->decimal('value');
			$table->text('description');
			$table->integer('user_id')->unsigned()->index();
			$table->integer('event_id')->unsigned()->index();
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}