<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Transaction extends Eloquent {

	protected $table = 'transactions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('value', 'description', 'user_id', 'event_id');

	public function events()
	{
		return $this->belongsTo('App\Event');
	}

	public function users()
	{
		return $this->belongsTo('App\User');
	}

	public function refunds()
	{
		return $this->hasMany('App\Refund');
	}

}