<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateApplicationsTable extends Migration {

	public function up()
	{
		Schema::create('applications', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('profile_id');
			$table->integer('job_id');
			$table->enum('status', array('Applied', 'Reviewed', 'Interview', 'Offerletter', 'Cancelled'));
			$table->string('cover_later', 250)->nullable();
			$table->string('resume_path', 255);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('applications');
	}
}