<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDocumentsTable extends Migration {

	public function up()
	{
		Schema::create('documents', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('profile_id');
			$table->enum('type', array('link', 'pdf', 'image'));
			$table->string('name', 200)->nullable();
			$table->integer('image_count');
			$table->enum('format', array(''images'', ''pdf'', ''url'', ''cv''));
			$table->string('path', 200);
			$table->string('url', 200)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('documents');
	}
}