<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobsTable extends Migration {

	public function up()
	{
		Schema::create('jobs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 200);
			$table->integer('company_id')->unsigned();
			$table->string('category_name');
			$table->string('jop_type', 255);
			$table->float('salary');
			$table->text('description');
			$table->text('requirement')->nullable();
			$table->enum('position', array('Internship', 'Entrylevel', 'Junior', 'Mid-level', 'Senior', 'Leader', 'Engineeringmanager'));
			$table->enum('job_status', array('Open', 'Closed', 'Cancelled'));
			$table->string('location', 255);
			$table->string('benefits', 255);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('jobs');
	}
}