<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->string('name', 200);
			$table->string('email', 200)->unique();
			$table->string('password', 200)->nullable();
			$table->bigInteger('provider_id')->unique()->nullable();
			$table->string('provider_name', 200)->nullable();
			$table->rememberToken('rememberToken');
			$table->boolean('confermed_email');
			$table->char('pin_code', 200);
			$table->timestamps();
			$table->datetime('pin_created_at')->nullable();
			$table->timestampTz('email_verified_at')->nullable();
			$table->string('fcm_token', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}