<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('jobs', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('admin_id')->references('id')->on('admins')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('jobs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('job_profile', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('profiles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('job_profile', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('jobs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notification_profile', function(Blueprint $table) {
			$table->foreign('notification_id')->references('id')->on('notifications')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notification_profile', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('profiles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('admins', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('application_status_histories', function(Blueprint $table) {
			$table->foreign('application_id')->references('id')->on('applications')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('role_has_permissions', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('role_has_permissions', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('jobs', function(Blueprint $table) {
			$table->dropForeign('jobs_company_id_foreign');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->dropForeign('profiles_user_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_admin_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_job_id_foreign');
		});
		Schema::table('job_profile', function(Blueprint $table) {
			$table->dropForeign('job_profile_profile_id_foreign');
		});
		Schema::table('job_profile', function(Blueprint $table) {
			$table->dropForeign('job_profile_job_id_foreign');
		});
		Schema::table('notification_profile', function(Blueprint $table) {
			$table->dropForeign('notification_profile_notification_id_foreign');
		});
		Schema::table('notification_profile', function(Blueprint $table) {
			$table->dropForeign('notification_profile_profile_id_foreign');
		});
		Schema::table('admins', function(Blueprint $table) {
			$table->dropForeign('admins_company_id_foreign');
		});
		Schema::table('application_status_histories', function(Blueprint $table) {
			$table->dropForeign('application_status_histories_application_id_foreign');
		});
		Schema::table('role_has_permissions', function(Blueprint $table) {
			$table->dropForeign('role_has_permissions_role_id_foreign');
		});
		Schema::table('role_has_permissions', function(Blueprint $table) {
			$table->dropForeign('role_has_permissions_permission_id_foreign');
		});
	}
}