<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertyUserTable extends Migration {

	public function up()
	{
		Schema::create('property_user', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('property_id')->unsigned()->nullable();
			$table->integer('user_profile_id')->unsigned()->nullable();
			$table->boolean('is_active')->default(1);
			$table->bigInteger('create_user_id')->unsigned();
			$table->bigInteger('edit_user_id')->unsigned()->nullable();
			$table->bigInteger('location_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('property_user');
	}
}