<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserSurveyProfilesTable extends Migration {

	public function up()
	{
		Schema::create('user_survey_profiles', function(Blueprint $table) {
			$table->bigInteger('id')->primary();
			$table->timestamps();
			$table->text('address')->nullable();
			$table->string('lattitude')->nullable();
			$table->integer('move_in_month')->nullable();
			$table->date('move_in')->nullable();
			$table->string('longtitude')->nullable();
			$table->bigInteger('user_id')->unsigned()->nullable();
			$table->boolean('is_active')->default(1);
			$table->softDeletes();
			$table->integer('min_travel_time')->nullable();
			$table->integer('max_travel_time')->nullable();
			$table->integer('garage')->nullable();
			$table->string('storey')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user_survey_profiles');
	}
}