<?php

namespace Property;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Property extends Eloquent {

	protected $table = 'properties';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function property_address()
	{
		return $this->hasOne('PropertyAddress');
	}

	public function property_info()
	{
		return $this->hasOne('PropertyInfo');
	}

	public function property_user()
	{
		return $this->belongsToMany('PropertyUser');
	}

	public function property_image()
	{
		return $this->hasMany('ProperttyImage');
	}

}