<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSetLocationTable extends Migration {

	public function up()
	{
		Schema::create('set_location', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('location')->nullable();
			$table->text('address')->nullable();
			$table->boolean('is_active')->default(1);
			$table->bigInteger('create_user_id')->unsigned()->nullable();
			$table->bigInteger('edit_user_id')->unsigned()->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('set_location');
	}
}