<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePurchasesTable extends Migration {

	public function up()
	{
		Schema::create('purchases', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->index();
			$table->integer('coupon_Id')->unsigned()->nullable();
			$table->datetime('date');
			$table->integer('price');
			$table->string('payment_type');
			$table->string('payment_reference');
			$table->string('payment_status');
			$table->string('payment_response_page')->nullable();
			$table->string('payment_confirmation_page')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('purchases');
	}
}