<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class QuestionListQuestion extends Model 
{

    protected $table = 'question_list_question';
    public $timestamps = false;

    public function requestAnswer()
    {
        return $this->hasMany('QuestionRequestAnswer');
    }

    public function question()
    {
        return $this->belongsTo('Question');
    }

    public function condition()
    {
        return $this->belongsTo('\QuestionListQuestion', 'id', 'question_list_question_id');
    }

    public function previous()
    {
        return $this->belongsTo('QuestionListQuestion', 'previous_question_list_question_id', 'id');
    }

}