<?php

class Question extends Eloquent {

	protected $table = 'question';
	public $timestamps = false;

	public function answers()
	{
		return $this->belongsToMany('Answer', 'question_answer', 'question_id', 'answer_id');
	}

	public function QuestionType()
	{
		return $this->belongsTo('QuestionType');
	}

	public function questionListQuestions()
	{
		return $this->hasMany('QuestionListQuestion');
	}

	public function questionLists()
	{
		return $this->belongsToMany('QuestionList', 'question_list_question', 'question_id', 'question_list_id');
	}

	public function questionGroups()
	{
		return $this->belongsToMany('App\QuestionGroup', 'question_group_id', 'question_id');
	}

}