<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name')->nullable();
			$table->string('last_name')->nullable();
			$table->string('email')->nullable();
			$table->string('mobile')->nullable();
			$table->string('image')->nullable();
			$table->tinyInteger('is_active')->nullable()->default('0');
			$table->tinyInteger('is_verified')->nullable()->default('0');
			$table->tinyInteger('is_admin')->nullable()->default('0');
			$table->string('registered_ip')->nullable();
			$table->string('logged_ip')->nullable();
			$table->string('country_code')->nullable();
			$table->string('time_zone')->nullable()->default('America/New_York');
			$table->datetime('login_time')->nullable();
			$table->datetime('logout_time')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}