<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewsTable extends Migration {

	public function up()
	{
		Schema::create('reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 120);
			$table->string('comment', 512);
			$table->float('average')->default('0');
			$table->integer('flagCount')->unsigned()->default('0');
			$table->integer('helpfulCount')->unsigned()->default('0');
			$table->integer('reviewable_id')->unsigned();
			$table->string('reviewable_type', 50);
		});
	}

	public function down()
	{
		Schema::drop('reviews');
	}
}