<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlacesTable extends Migration {

	public function up()
	{
		Schema::create('places', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 50);
			$table->string('shortDescription', 155);
			$table->text('description');
			$table->string('hashtags', 155)->nullable();
			$table->decimal('lat', 10,8);
			$table->decimal('long', 11,8);
			$table->text('tariff')->nullable();
			$table->boolean('isFeatured')->default(false);
			$table->integer('id_contact_info')->unsigned()->nullable();
			$table->integer('place_type_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('places');
	}
}