<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Place extends Eloquent {

	protected $table = 'places';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function contactInfo()
	{
		return $this->hasOne('ContactInfo', 'id_contact_info');
	}

	public function placeType()
	{
		return $this->hasOne('PlaceType', 'place_type_id');
	}

	public function deals()
	{
		return $this->hasMany('Deal');
	}

}