<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Supplier extends Model 
{

    protected $table = 'suppliers';
    public $timestamps = true;

    public function item()
    {
        return $this->belongsTo('Item');
    }

    public function bank()
    {
        return $this->hasOne('Bank');
    }

    public function address()
    {
        return $this->hasOne('Adress');
    }

    public function contract()
    {
        return $this->hasOne('Contract');
    }

    public function payment()
    {
        return $this->hasOne('Payment');
    }

    public function receipt()
    {
        return $this->hasOne('Receipt');
    }

}