<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBanksTable extends Migration {

	public function up()
	{
		Schema::create('banks', function(Blueprint $table) {
			$table->increments('id');
			$table->string('swift_code');
			$table->string('iban');
			$table->string('name');
			$table->string('address');
			$table->string('country');
			$table->string('currency');
			$table->timestamps();
			$table->integer('supplier_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('banks');
	}
}