<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTaxonomyOptionsTable extends Migration {

	public function up()
	{
		Schema::create('taxonomy_options', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('uuid')->unique();
			$table->integer('taxonomy_id')->unsigned()->nullable();
			$table->string('value')->nullable()->index();
			$table->string('label')->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('taxonomy_options');
	}
}