<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAnswersTable extends Migration {

	public function up()
	{
		Schema::create('answers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->text('answer_ar');
			$table->text('answer_en');
			$table->enum('type', array('orders', 'charge', 'exchange&return', 'pay', 'products'));
			$table->integer('question_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('answers');
	}
}