<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title');
			$table->text('body');
			$table->enum('type', array('pending', 'accepted', 'delivered'));
			$table->integer('client_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}