<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name_ar');
			$table->string('name_en');
			$table->string('image');
			$table->string('price');
			$table->string('discount');
			$table->boolean('is_active')->default(0);
			$table->string('colour');
			$table->string('size');
			$table->text('description_ar');
			$table->text('description_en');
			$table->integer('quantity');
			$table->string('offer_duration')->nullable();
			$table->enum('state', array('new', 'used'));
			$table->string('available_quantity');
			$table->integer('store_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}