<?php

namespace Vanguard;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'Users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function brands()
    {
        return $this->belongsToMany('Vanguard\Brand');
    }

    public function requests()
    {
        return $this->hasMany('Vanguard\User');
    }

    public function orders()
    {
        return $this->hasMany('\Order');
    }

}