<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('tenent_id')->references('id')->on('tenents')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tenents', function(Blueprint $table) {
			$table->foreign('app_id')->references('id')->on('apps')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Transactions', function(Blueprint $table) {
			$table->foreign('tenent_id')->references('id')->on('tenents')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_tenent_id_foreign');
		});
		Schema::table('tenents', function(Blueprint $table) {
			$table->dropForeign('tenents_app_id_foreign');
		});
		Schema::table('Transactions', function(Blueprint $table) {
			$table->dropForeign('Transactions_tenent_id_foreign');
		});
	}
}