<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Passenger extends Eloquent {

	protected $table = 'passengers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function journey()
	{
		return $this->belongsTo('Journey');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function status()
	{
		return $this->belongsTo('Status');
	}

	public function receivedOpinion()
	{
		return $this->hasOne('Opinion');
	}

	public function writtedOpinion()
	{
		return $this->hasOne('Opinion');
	}

}