<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function addresse()
	{
		return $this->belongsTo('Addresse');
	}

	public function verifications()
	{
		return $this->hasMany('Verification');
	}

	public function journeys()
	{
		return $this->hasMany('Journey');
	}

	public function passengers()
	{
		return $this->hasMany('Passenger');
	}

	public function devices()
	{
		return $this->hasMany('Device');
	}

	public function receivedOpinions()
	{
		return $this->hasMany('\Opinion');
	}

	public function writtedOpinions()
	{
		return $this->hasMany('Opinion', 'writer_id');
	}

}