<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('insureds', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('insureds')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('insurance_contracts', function(Blueprint $table) {
			$table->foreign('insured_id')->references('id')->on('insureds')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('doctors', function(Blueprint $table) {
			$table->foreign('specialization_id')->references('id')->on('insureds')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('doctors', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('insureds')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('visits', function(Blueprint $table) {
			$table->foreign('insured_id')->references('id')->on('insureds')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('visits', function(Blueprint $table) {
			$table->foreign('contract_id')->references('id')->on('insureds')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('visits', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('insureds')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('diagnoses', function(Blueprint $table) {
			$table->foreign('visit_id')->references('id')->on('insureds')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contract_service', function(Blueprint $table) {
			$table->foreign('contract_id')->references('id')->on('insureds')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contract_service', function(Blueprint $table) {
			$table->foreign('medical_service_id')->references('id')->on('insureds')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('visit_medicine', function(Blueprint $table) {
			$table->foreign('visit_id')->references('id')->on('insureds')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rejection', function(Blueprint $table) {
			$table->foreign('visit_id')->references('id')->on('insureds')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('insureds', function(Blueprint $table) {
			$table->dropForeign('insureds_address_id_foreign');
		});
		Schema::table('insurance_contracts', function(Blueprint $table) {
			$table->dropForeign('insurance_contracts_insured_id_foreign');
		});
		Schema::table('doctors', function(Blueprint $table) {
			$table->dropForeign('doctors_specialization_id_foreign');
		});
		Schema::table('doctors', function(Blueprint $table) {
			$table->dropForeign('doctors_address_id_foreign');
		});
		Schema::table('visits', function(Blueprint $table) {
			$table->dropForeign('visits_insured_id_foreign');
		});
		Schema::table('visits', function(Blueprint $table) {
			$table->dropForeign('visits_contract_id_foreign');
		});
		Schema::table('visits', function(Blueprint $table) {
			$table->dropForeign('visits_doctor_id_foreign');
		});
		Schema::table('diagnoses', function(Blueprint $table) {
			$table->dropForeign('diagnoses_visit_id_foreign');
		});
		Schema::table('contract_service', function(Blueprint $table) {
			$table->dropForeign('contract_service_contract_id_foreign');
		});
		Schema::table('contract_service', function(Blueprint $table) {
			$table->dropForeign('contract_service_medical_service_id_foreign');
		});
		Schema::table('visit_medicine', function(Blueprint $table) {
			$table->dropForeign('visit_medicine_visit_id_foreign');
		});
		Schema::table('rejection', function(Blueprint $table) {
			$table->dropForeign('rejection_visit_id_foreign');
		});
	}
}