<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMobileLanguagesTable extends Migration {

	public function up()
	{
		Schema::create('mobile_languages', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('english', 255)->nullable();
			$table->string('french', 255)->nullable();
			$table->string('spanish', 255)->nullable();
			$table->bigInteger('created_by')->unsigned();
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('mobile_languages');
	}
}