<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertyAddressesTable extends Migration {

	public function up()
	{
		Schema::create('property_addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('property_id')->unsigned();
			$table->string('street_address', 100);
			$table->string('land_mark', 100);
			$table->string('zip_code', 10);
			$table->string('latitude', 20)->nullable();
			$table->string('longitude', 20)->nullable();
			$table->bigInteger('city_id')->unsigned();
			$table->bigInteger('state_id')->unsigned();
			$table->bigInteger('country_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('property_addresses');
	}
}