<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PropertiesRule extends Eloquent {

	protected $table = 'properties_rules';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function properties()
	{
		return $this->belongsToMany('PropertyRule', 'rule_id');
	}

	public function property_type()
	{
		return $this->belongsTo('App\Models\PropertyType', 'property_type_id');
	}

}