<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVendorsTable extends Migration {

	public function up()
	{
		Schema::create('vendors', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->index();
			$table->string('email')->nullable();
			$table->string('phone_number')->index();
			$table->integer('zone_id')->unsigned();
			$table->text('adress')->nullable();
			$table->string('license_number')->nullable();
			$table->string('owner_name')->index();
			$table->string('contact_number')->nullable();
			$table->string('owner_phone_number')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('vendors');
	}
}