<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('gateway_id');
			$table->integer('payment_id');
			$table->integer('order_id');
			$table->bigInteger('amount');
			$table->enum('status', array('pending', 'failed', 'success'));
			$table->string('res_id');
			$table->string('code');
			$table->json('description');
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}