<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvitesTable extends Migration {

	public function up()
	{
		Schema::create('invites', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned();
			$table->string('full_name')->nullable();
			$table->string('email')->nullable();
			$table->bigInteger('phone')->nullable();
			$table->string('address')->nullable();
			$table->string('organization')->nullable();
			$table->string('type');
			$table->time('time');
			$table->date('date');
			$table->string('notes');
		});
	}

	public function down()
	{
		Schema::drop('invites');
	}
}