<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVisitorsTable extends Migration {

	public function up()
	{
		Schema::create('visitors', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned()->nullable();
			$table->bigInteger('company_id')->unsigned()->nullable();
			$table->string('full_name');
			$table->string('email');
			$table->string('phone')->nullable();
			$table->string('address');
			$table->string('organization');
			$table->string('type');
			$table->string('photo')->nullable();
			$table->time('time');
			$table->date('date');
			$table->string('notes');
		});
	}

	public function down()
	{
		Schema::drop('visitors');
	}
}