<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustodyTable extends Migration {

	public function up()
	{
		Schema::create('custody', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('country_id')->nullable();
			$table->integer('mall_id')->nullable();
			$table->integer('employee_id')->nullable();
			$table->integer('category_id')->nullable();
			$table->integer('data_id')->nullable();
			$table->text('notes_en')->nullable();
			$table->text('notes_ar')->nullable();
			$table->integer('number')->nullable();
			$table->datetime('date')->nullable();
			$table->enum('status', array('delivered', 'received'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('custody');
	}
}