<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDeductionTable extends Migration {

	public function up()
	{
		Schema::create('deduction', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('account_id')->nullable();
			$table->integer('country_id')->nullable();
			$table->integer('mall_id')->nullable();
			$table->integer('employee_id')->nullable();
			$table->integer('type_id')->nullable();
			$table->double('amount')->nullable();
			$table->datetime('date')->nullable();
			$table->enum('status', array('unpaid', 'partial', 'paid'))->nullable();
			$table->text('notes_en')->nullable();
			$table->text('notes_ar')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('deduction');
	}
}