<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReceiptTable extends Migration {

	public function up()
	{
		Schema::create('receipt', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('country_id')->nullable();
			$table->integer('mall_id')->nullable();
			$table->integer('employee_id')->nullable();
			$table->integer('account_id')->nullable();
			$table->enum('type', array('cash', 'payment'))->nullable();
			$table->datetime('date')->nullable();
			$table->double('amount')->nullable();
			$table->string('allocate')->nullable();
			$table->integer('allocate_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('receipt');
	}
}