<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionTable extends Migration {

	public function up()
	{
		Schema::create('transaction', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('country_id')->nullable();
			$table->integer('mall_id')->nullable();
			$table->datetime('date')->nullable();
			$table->integer('account_id')->nullable();
			$table->string('type')->nullable();
			$table->text('description_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->double('debit')->nullable();
			$table->double('credit')->nullable();
			$table->double('balance')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('transaction');
	}
}