<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWebhookRequestsTable extends Migration {

	public function up()
	{
		Schema::create('webhook_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('webhook_id')->unsigned();
			$table->json('request_body')->nullable();
			$table->string('response_body')->nullable();
			$table->mediumInteger('status')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('webhook_requests');
	}
}