<?php

namespace Jiri;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Score extends Eloquent {

	protected $table = 'scores';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'implementation_id', 'score', 'comment');

	public function meeting()
	{
		return $this->belongsTo('Impression');
	}

	public function implementation()
	{
		return $this->belongsTo('Implementation');
	}

}