<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewsTable extends Migration {

	public function up()
	{
		Schema::create('reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->float('rating')->nullable()->default('0');
			$table->text('description')->nullable();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('course_id')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('reviews');
	}
}