<?php

namespace app/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class LessonAttachment extends Eloquent {

	protected $table = 'lesson_attachments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'url', 'lesson_id');

	public function lesson()
	{
		return $this->belongsTo('Lesson');
	}

}