<?php

namespace Dvlop;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Gallery extends Eloquent {

	protected $table = 'galleries';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'slug', 'product_partner_id', 'preset_id');

	public function tags()
	{
		return $this->morphToMany('Tag');
	}

	public function images()
	{
		return $this->hasMany('GalleryImage');
	}

	public function photographyStudio()
	{
		return $this->belongsTo('ProductPartner');
	}

	public function preset()
	{
		return $this->belongsTo('Preset');
	}

}