<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name');
			$table->string('last_name');
			$table->string('email')->unique();
			$table->string('username')->unique();
			$table->string('password');
			$table->string('address_street_1')->nullable();
			$table->string('address_street_2')->nullable();
			$table->string('address_city')->nullable();
			$table->string('address_state_province')->nullable();
			$table->string('address_postal_code', 12)->nullable();
			$table->string('address_country_code', 3)->nullable();
			$table->string('phone_number', 15)->nullable();
			$table->rememberToken('rememberToken');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}