<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserProfileTable extends Migration {

	public function up()
	{
		Schema::create('user_profile', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('company_name');
			$table->string('brand_name');
			$table->string('account_type');
			$table->string('address');
			$table->string('address_2');
			$table->string('pincode');
			$table->string('state');
			$table->string('city');
			$table->string('gst_no');
			$table->string('pan_no');
			$table->string('status');
			$table->string('max_cod_value');
			$table->string('freight_type');
			$table->string('liability_shipment');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_profile');
	}
}