<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('email');
			$table->string('password');
			$table->string('photo');
			$table->boolean('status');
			$table->enum('user_type', array('admin', 'school', 'training_center', 'teacher', 'instructor', 'parent', 'student'));
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}