<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriasTable extends Migration {

	public function up()
	{
		Schema::create('categorias', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_padre')->unsigned();
			$table->integer('google_product_category');
			$table->boolean('es_escondida')->default(FALSE);
			$table->text('nombre')->nullable();
			$table->integer('orden');
			$table->string('imagen_home', 255);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('categorias');
	}
}